#include "../include/typedefs.h"

// Example code from MISRA C:2012 begin
extern void f ( signed int );
       void f (        int );   /* Compliant - Exception */
extern void g ( int * const );
       void g ( int *       );  /* Non-compliant - type qualifiers */

extern int16_t func ( int16_t num, int16_t den );

/* Non-compliant - parameter names do not match */
int16_t func ( int16_t den, int16_t num )
{
  return num / den;
}

typedef uint16_t width_t;
typedef uint16_t height_t;
typedef uint32_t area_t;

extern area_t area ( width_t w, height_t h );

/* Non-compliant */
area_t area ( width_t w, width_t h )
{
  return ( area_t ) w * h;
}

/* Compliant */
extern void f1 ( int16_t x );
extern void f2 ( int16_t y );

void f3 ( bool b )
{
  void ( *fp1 ) ( int16_t z ) = b ? f1 : f2;
}
// Example code from MISRA C:2012 end
